<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی ادمین بودن کاربر
checkAdmin();

// آمار سایت
$stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE is_admin = 0");
$stats['users'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM notes WHERE is_active = 1");
$stats['notes'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM reports WHERE status = 'pending'");
$stats['pending_reports'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM subjects");
$stats['subjects'] = $stmt->fetch()['total'];
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت - جزوه هاب</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <!-- نوار کناری -->
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <img src="../assets/images/logo.png" alt="Logo" class="sidebar-logo">
                <h2>پنل مدیریت</h2>
                <p><?php echo $_SESSION['full_name']; ?></p>
            </div>
            
            <nav class="sidebar-nav">
                <a href="index.php" class="nav-item active">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>داشبورد</span>
                </a>
                <a href="upload.php" class="nav-item">
                    <i class="fas fa-upload"></i>
                    <span>آپلود جزوه</span>
                </a>
                <a href="users.php" class="nav-item">
                    <i class="fas fa-users"></i>
                    <span>مدیریت کاربران</span>
                </a>
                <a href="reports.php" class="nav-item">
                    <i class="fas fa-flag"></i>
                    <span>گزارشات</span>
                    <?php if ($stats['pending_reports'] > 0): ?>
                        <span class="badge"><?php echo $stats['pending_reports']; ?></span>
                    <?php endif; ?>
                </a>
                <a href="../dashboard.php" class="nav-item">
                    <i class="fas fa-home"></i>
                    <span>بازگشت به سایت</span>
                </a>
                <a href="../logout.php" class="nav-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>خروج</span>
                </a>
            </nav>
        </aside>

        <!-- محتوای اصلی -->
        <main class="admin-main">
            <header class="admin-header">
                <h1>داشبورد مدیریت</h1>
                <div class="header-actions">
                    <span class="welcome">خوش آمدید مدیر سیستم</span>
                </div>
            </header>

            <div class="admin-content">
                <!-- کارت‌های آمار -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon users">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $stats['users']; ?></h3>
                            <p>کاربران</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon notes">
                            <i class="fas fa-book"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $stats['notes']; ?></h3>
                            <p>جزوات</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon reports">
                            <i class="fas fa-flag"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $stats['pending_reports']; ?></h3>
                            <p>گزارشات در انتظار</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon subjects">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $stats['subjects']; ?></h3>
                            <p>دروس</p>
                        </div>
                    </div>
                </div>

                <!-- بخش‌های سریع -->
                <div class="quick-actions-grid">
                    <a href="upload.php" class="quick-action">
                        <i class="fas fa-upload"></i>
                        <span>آپلود جزوه جدید</span>
                    </a>
                    
                    <a href="users.php" class="quick-action">
                        <i class="fas fa-user-plus"></i>
                        <span>ایجاد کاربر جدید</span>
                    </a>
                    
                    <a href="reports.php" class="quick-action">
                        <i class="fas fa-flag"></i>
                        <span>مشاهده گزارشات</span>
                    </a>
                    
                    <a href="users.php?action=manage" class="quick-action">
                        <i class="fas fa-cog"></i>
                        <span>مدیریت کاربران</span>
                    </a>
                </div>

                <!-- آخرین فعالیت‌ها -->
                <div class="recent-activity">
                    <h2>آخرین فعالیت‌ها</h2>
                    <div class="activity-list">
                        <?php
                        $stmt = $pdo->query("
                            SELECT n.title, n.created_at, s.name as subject_name, 
                                   u.full_name as uploader 
                            FROM notes n 
                            JOIN subjects s ON n.subject_id = s.id 
                            JOIN users u ON n.uploaded_by = u.id 
                            ORDER BY n.created_at DESC 
                            LIMIT 5
                        ");
                        $activities = $stmt->fetchAll();
                        
                        foreach ($activities as $activity):
                        ?>
                        <div class="activity-item">
                            <div class="activity-icon">
                                <i class="fas fa-book"></i>
                            </div>
                            <div class="activity-content">
                                <p><strong><?php echo $activity['uploader']; ?></strong> جزوه جدید آپلود کرد</p>
                                <p class="activity-details"><?php echo $activity['title']; ?> - <?php echo $activity['subject_name']; ?></p>
                                <span class="activity-time"><?php echo time_ago($activity['created_at']); ?></span>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script src="../assets/js/admin.js"></script>
</body>
</html>