<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی ادمین بودن کاربر
checkAdmin();

$action = $_GET['action'] ?? 'list';
$id = $_GET['id'] ?? 0;
$error = '';
$success = '';

// عملیات بر روی گزارشات
if ($action == 'view' && $id) {
    // مشاهده گزارش
    $stmt = $pdo->prepare("
        SELECT r.*, u.full_name as reporter_name, n.title as note_title
        FROM reports r
        JOIN users u ON r.user_id = u.id
        JOIN notes n ON r.note_id = n.id
        WHERE r.id = ?
    ");
    $stmt->execute([$id]);
    $report = $stmt->fetch();
    
    if (!$report) {
        $error = 'گزارش یافت نشد';
    }
    
    // بروزرسانی وضعیت به "مشاهده شده"
    $stmt = $pdo->prepare("UPDATE reports SET status = 'seen' WHERE id = ?");
    $stmt->execute([$id]);
    
} elseif ($action == 'resolve' && $id) {
    // حل گزارش
    $stmt = $pdo->prepare("UPDATE reports SET status = 'resolved', resolved_at = NOW() WHERE id = ?");
    $stmt->execute([$id]);
    $success = 'گزارش به عنوان حل‌شده علامت‌گذاری شد';
    
} elseif ($action == 'delete' && $id) {
    // حذف گزارش
    $stmt = $pdo->prepare("DELETE FROM reports WHERE id = ?");
    $stmt->execute([$id]);
    $success = 'گزارش حذف شد';
}

// دریافت گزارشات
$status = $_GET['status'] ?? 'all';
$query = "
    SELECT r.*, u.full_name as reporter_name, n.title as note_title,
           s.name as subject_name
    FROM reports r
    JOIN users u ON r.user_id = u.id
    JOIN notes n ON r.note_id = n.id
    JOIN subjects s ON n.subject_id = s.id
";

if ($status != 'all') {
    $query .= " WHERE r.status = ?";
    $stmt = $pdo->prepare($query . " ORDER BY r.created_at DESC");
    $stmt->execute([$status]);
} else {
    $stmt = $pdo->query($query . " ORDER BY r.created_at DESC");
}

$reports = $stmt->fetchAll();

// آمار گزارشات
$stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as total FROM reports WHERE status = 'pending'");
$stats['pending'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM reports WHERE status = 'seen'");
$stats['seen'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM reports WHERE status = 'resolved'");
$stats['resolved'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM reports");
$stats['all'] = $stmt->fetch()['total'];
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارشات - پنل مدیریت</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <img src="../assets/images/logo.png" alt="Logo" class="sidebar-logo">
                <h2>پنل مدیریت</h2>
            </div>
            
            <nav class="sidebar-nav">
                <a href="index.php" class="nav-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>داشبورد</span>
                </a>
                <a href="upload.php" class="nav-item">
                    <i class="fas fa-upload"></i>
                    <span>آپلود جزوه</span>
                </a>
                <a href="users.php" class="nav-item">
                    <i class="fas fa-users"></i>
                    <span>مدیریت کاربران</span>
                </a>
                <a href="reports.php" class="nav-item active">
                    <i class="fas fa-flag"></i>
                    <span>گزارشات</span>
                    <?php if ($stats['pending'] > 0): ?>
                        <span class="badge"><?php echo $stats['pending']; ?></span>
                    <?php endif; ?>
                </a>
                <a href="../dashboard.php" class="nav-item">
                    <i class="fas fa-home"></i>
                    <span>بازگشت به سایت</span>
                </a>
                <a href="../logout.php" class="nav-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>خروج</span>
                </a>
            </nav>
        </aside>

        <main class="admin-main">
            <header class="admin-header">
                <h1>مدیریت گزارشات</h1>
                <div class="header-actions">
                    <div class="filter-buttons">
                        <a href="?status=all" class="btn btn-small <?php echo $status == 'all' ? 'btn-primary' : 'btn-secondary'; ?>">همه</a>
                        <a href="?status=pending" class="btn btn-small <?php echo $status == 'pending' ? 'btn-primary' : 'btn-secondary'; ?>">
                            در انتظار (<?php echo $stats['pending']; ?>)
                        </a>
                        <a href="?status=seen" class="btn btn-small <?php echo $status == 'seen' ? 'btn-primary' : 'btn-secondary'; ?>">
                            مشاهده شده (<?php echo $stats['seen']; ?>)
                        </a>
                        <a href="?status=resolved" class="btn btn-small <?php echo $status == 'resolved' ? 'btn-primary' : 'btn-secondary'; ?>">
                            حل شده (<?php echo $stats['resolved']; ?>)
                        </a>
                    </div>
                </div>
            </header>

            <div class="admin-content">
                <?php if ($error): ?>
                    <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <?php if ($action == 'view' && isset($report)): ?>
                    <!-- مشاهده گزارش -->
                    <div class="report-details">
                        <div class="report-header">
                            <h2>جزئیات گزارش</h2>
                            <div class="report-meta">
                                <span class="status-badge <?php echo $report['status']; ?>">
                                    <?php 
                                    $status_labels = [
                                        'pending' => 'در انتظار',
                                        'seen' => 'مشاهده شده',
                                        'resolved' => 'حل شده'
                                    ];
                                    echo $status_labels[$report['status']] ?? $report['status'];
                                    ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="report-info">
                            <div class="info-row">
                                <span class="info-label">گزارش‌دهنده:</span>
                                <span class="info-value"><?php echo $report['reporter_name']; ?></span>
                            </div>
                            
                            <div class="info-row">
                                <span class="info-label">جزوه مرتبط:</span>
                                <span class="info-value"><?php echo $report['note_title']; ?></span>
                            </div>
                            
                            <div class="info-row">
                                <span class="info-label">درس:</span>
                                <span class="info-value"><?php echo $report['subject_name']; ?></span>
                            </div>
                            
                            <div class="info-row">
                                <span class="info-label">تاریخ گزارش:</span>
                                <span class="info-value"><?php echo jdate('Y/m/d H:i', strtotime($report['created_at'])); ?></span>
                            </div>
                            
                            <?php if ($report['resolved_at']): ?>
                            <div class="info-row">
                                <span class="info-label">تاریخ حل:</span>
                                <span class="info-value"><?php echo jdate('Y/m/d H:i', strtotime($report['resolved_at'])); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="report-content">
                            <h3>متن گزارش:</h3>
                            <div class="content-box">
                                <?php echo nl2br(htmlspecialchars($report['description'])); ?>
                            </div>
                        </div>
                        
                        <div class="report-actions">
                            <?php if ($report['status'] != 'resolved'): ?>
                                <a href="?action=resolve&id=<?php echo $report['id']; ?>" 
                                   class="btn btn-success" onclick="return confirm('آیا گزارش حل شده است؟')">
                                    <i class="fas fa-check"></i> علامت‌گذاری به عنوان حل‌شده
                                </a>
                            <?php endif; ?>
                            
                            <a href="?action=delete&id=<?php echo $report['id']; ?>" 
                               class="btn btn-danger" onclick="return confirm('آیا از حذف این گزارش مطمئن هستید؟')">
                                <i class="fas fa-trash"></i> حذف گزارش
                            </a>
                            
                            <a href="reports.php" class="btn btn-secondary">بازگشت به لیست</a>
                        </div>
                    </div>
                    
                <?php else: ?>
                    <!-- لیست گزارشات -->
                    <?php if (empty($reports)): ?>
                        <div class="empty-state">
                            <i class="fas fa-flag"></i>
                            <h3>هیچ گزارشی یافت نشد</h3>
                            <p>در حال حاضر هیچ گزارشی ثبت نشده است.</p>
                        </div>
                    <?php else: ?>
                        <div class="table-container">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>ردیف</th>
                                        <th>گزارش‌دهنده</th>
                                        <th>جزوه</th>
                                        <th>درس</th>
                                        <th>تاریخ</th>
                                        <th>وضعیت</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($reports as $index => $report): ?>
                                    <tr>
                                        <td><?php echo $index + 1; ?></td>
                                        <td><?php echo $report['reporter_name']; ?></td>
                                        <td>
                                            <a href="../notes/view.php?id=<?php echo $report['note_id']; ?>" target="_blank">
                                                <?php echo $report['note_title']; ?>
                                            </a>
                                        </td>
                                        <td><?php echo $report['subject_name']; ?></td>
                                        <td><?php echo jdate('Y/m/d', strtotime($report['created_at'])); ?></td>
                                        <td>
                                            <span class="status-badge <?php echo $report['status']; ?>">
                                                <?php 
                                                $status_labels = [
                                                    'pending' => 'در انتظار',
                                                    'seen' => 'مشاهده شده',
                                                    'resolved' => 'حل شده'
                                                ];
                                                echo $status_labels[$report['status']] ?? $report['status'];
                                                ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="action-buttons">
                                                <a href="?action=view&id=<?php echo $report['id']; ?>" 
                                                   class="btn btn-small btn-info" title="مشاهده">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if ($report['status'] != 'resolved'): ?>
                                                    <a href="?action=resolve&id=<?php echo $report['id']; ?>" 
                                                       class="btn btn-small btn-success" title="حل شده"
                                                       onclick="return confirm('آیا گزارش حل شده است؟')">
                                                        <i class="fas fa-check"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="?action=delete&id=<?php echo $report['id']; ?>" 
                                                   class="btn btn-small btn-danger" title="حذف"
                                                   onclick="return confirm('آیا از حذف این گزارش مطمئن هستید؟')">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="table-info">
                            <p>تعداد گزارشات: <strong><?php echo count($reports); ?></strong> مورد</p>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </main>
    </div>

    <script src="../assets/js/admin.js"></script>
</body>
</html>