<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی ادمین بودن کاربر
checkAdmin();

$error = '';
$success = '';

// دریافت دروس برای dropdown
$stmt = $pdo->query("SELECT * FROM subjects ORDER BY category, name");
$subjects = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = sanitize($_POST['title']);
    $subject_id = sanitize($_POST['subject_id']);
    $description = sanitize($_POST['description']);
    $prevent_download = isset($_POST['prevent_download']) ? 1 : 0;
    
    // اعتبارسنجی فایل
    if (isset($_FILES['pdf_file']) && $_FILES['pdf_file']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['pdf_file'];
        $file_name = sanitize($file['name']);
        $file_tmp = $file['tmp_name'];
        $file_size = $file['size'];
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        
        // بررسی نوع فایل
        $allowed_extensions = ['pdf'];
        if (!in_array($file_ext, $allowed_extensions)) {
            $error = 'فقط فایل‌های PDF مجاز هستند';
        } elseif ($file_size > 50 * 1024 * 1024) { // 50MB
            $error = 'حجم فایل باید کمتر از ۵۰ مگابایت باشد';
        } else {
            // تولید نام یکتا برای فایل
            $unique_name = uniqid() . '_' . time() . '.pdf';
            $upload_path = '../uploads/notes/' . $unique_name;
            
            if (move_uploaded_file($file_tmp, $upload_path)) {
                // ذخیره در دیتابیس
                $stmt = $pdo->prepare("
                    INSERT INTO notes (title, subject_id, description, file_path, 
                                      prevent_download, uploaded_by, created_at)
                    VALUES (?, ?, ?, ?, ?, ?, NOW())
                ");
                $stmt->execute([
                    $title, 
                    $subject_id, 
                    $description, 
                    $unique_name,
                    $prevent_download,
                    $_SESSION['user_id']
                ]);
                
                $success = 'جزوه با موفقیت آپلود شد';
                
                // بازنشانی فرم
                $_POST = array();
            } else {
                $error = 'خطا در آپلود فایل';
            }
        }
    } else {
        $error = 'لطفا فایل PDF را انتخاب کنید';
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>آپلود جزوه - پنل مدیریت</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <img src="../assets/images/logo.png" alt="Logo" class="sidebar-logo">
                <h2>پنل مدیریت</h2>
            </div>
            
            <nav class="sidebar-nav">
                <a href="index.php" class="nav-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>داشبورد</span>
                </a>
                <a href="upload.php" class="nav-item active">
                    <i class="fas fa-upload"></i>
                    <span>آپلود جزوه</span>
                </a>
                <a href="users.php" class="nav-item">
                    <i class="fas fa-users"></i>
                    <span>مدیریت کاربران</span>
                </a>
                <a href="reports.php" class="nav-item">
                    <i class="fas fa-flag"></i>
                    <span>گزارشات</span>
                </a>
                <a href="../dashboard.php" class="nav-item">
                    <i class="fas fa-home"></i>
                    <span>بازگشت به سایت</span>
                </a>
                <a href="../logout.php" class="nav-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>خروج</span>
                </a>
            </nav>
        </aside>

        <main class="admin-main">
            <header class="admin-header">
                <h1>آپلود جزوه جدید</h1>
                <div class="header-actions">
                    <a href="index.php" class="btn btn-secondary">بازگشت</a>
                </div>
            </header>

            <div class="admin-content">
                <?php if ($error): ?>
                    <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <div class="upload-form-container">
                    <form method="POST" action="" enctype="multipart/form-data" class="upload-form">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="title">عنوان جزوه *</label>
                                <input type="text" id="title" name="title" 
                                       value="<?php echo $_POST['title'] ?? ''; ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="subject_id">درس *</label>
                                <select id="subject_id" name="subject_id" required>
                                    <option value="">انتخاب درس</option>
                                    <optgroup label="دروس تخصصی">
                                        <?php foreach ($subjects as $subject): 
                                            if ($subject['category'] == 'specialized'): ?>
                                            <option value="<?php echo $subject['id']; ?>" 
                                                    <?php echo (isset($_POST['subject_id']) && $_POST['subject_id'] == $subject['id']) ? 'selected' : ''; ?>>
                                                <?php echo $subject['name']; ?>
                                            </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </optgroup>
                                    <optgroup label="دروس عمومی">
                                        <?php foreach ($subjects as $subject): 
                                            if ($subject['category'] == 'general'): ?>
                                            <option value="<?php echo $subject['id']; ?>" 
                                                    <?php echo (isset($_POST['subject_id']) && $_POST['subject_id'] == $subject['id']) ? 'selected' : ''; ?>>
                                                <?php echo $subject['name']; ?>
                                            </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </optgroup>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">توضیحات</label>
                            <textarea id="description" name="description" rows="3"><?php echo $_POST['description'] ?? ''; ?></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="pdf_file">فایل PDF *</label>
                            <div class="file-upload">
                                <input type="file" id="pdf_file" name="pdf_file" 
                                       accept=".pdf" required>
                                <div class="file-upload-info">
                                    <i class="fas fa-file-pdf"></i>
                                    <span>فایل PDF را اینجا رها کنید یا کلیک کنید</span>
                                    <small>حداکثر حجم: 50MB</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group checkbox-group">
                            <input type="checkbox" id="prevent_download" name="prevent_download" 
                                   value="1" <?php echo isset($_POST['prevent_download']) ? 'checked' : ''; ?>>
                            <label for="prevent_download">
                                <i class="fas fa-shield-alt"></i>
                                جلوگیری از دانلود
                            </label>
                            <small class="help-text">با فعال کردن این گزینه، کاربران فقط می‌توانند جزوه را مشاهده کنند و امکان دانلود نخواهند داشت.</small>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-upload"></i> آپلود جزوه
                            </button>
                            <button type="reset" class="btn btn-secondary">پاک کردن فرم</button>
                        </div>
                    </form>
                    
                    <div class="upload-instructions">
                        <h3>راهنمای آپلود</h3>
                        <ul>
                            <li>فقط فایل‌های PDF قابل قبول هستند</li>
                            <li>حداکثر حجم فایل: 50 مگابایت</li>
                            <li>عنوان باید توصیفی و واضح باشد</li>
                            <li>درس مرتبط را دقیقاً انتخاب کنید</li>
                            <li>گزینه "جلوگیری از دانلود" برای امنیت بیشتر</li>
                        </ul>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <script src="../assets/js/admin.js"></script>
</body>
</html>