<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی ادمین بودن کاربر
checkAdmin();

$action = $_GET['action'] ?? 'list';
$id = $_GET['id'] ?? 0;
$error = '';
$success = '';

// عملیات مختلف
switch ($action) {
    case 'create':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $national_code = sanitize($_POST['national_code']);
            $full_name = sanitize($_POST['full_name']);
            $password = '1234'; // رمز پیش‌فرض
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            // بررسی وجود کد ملی
            $stmt = $pdo->prepare("SELECT id FROM users WHERE national_code = ?");
            $stmt->execute([$national_code]);
            if ($stmt->rowCount() > 0) {
                $error = 'این کد ملی قبلاً ثبت شده است';
            } else {
                // ایجاد کاربر جدید
                $stmt = $pdo->prepare("
                    INSERT INTO users (national_code, full_name, password, must_change_password, created_at)
                    VALUES (?, ?, ?, 1, NOW())
                ");
                $stmt->execute([$national_code, $full_name, $hashed_password]);
                $success = 'کاربر با موفقیت ایجاد شد. رمز عبور: 1234';
            }
        }
        break;
        
    case 'edit':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $full_name = sanitize($_POST['full_name']);
            $password = sanitize($_POST['password']);
            
            if (!empty($password)) {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("
                    UPDATE users SET full_name = ?, password = ?, must_change_password = 1 
                    WHERE id = ?
                ");
                $stmt->execute([$full_name, $hashed_password, $id]);
            } else {
                $stmt = $pdo->prepare("UPDATE users SET full_name = ? WHERE id = ?");
                $stmt->execute([$full_name, $id]);
            }
            
            $success = 'اطلاعات کاربر با موفقیت بروزرسانی شد';
        }
        
        // دریافت اطلاعات کاربر
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$id]);
        $user = $stmt->fetch();
        break;
        
    case 'delete':
        $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND is_admin = 0");
        $stmt->execute([$id]);
        $success = 'کاربر با موفقیت حذف شد';
        break;
        
    case 'reset_password':
        $new_password = '1234';
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("
            UPDATE users SET password = ?, must_change_password = 1 
            WHERE id = ? AND is_admin = 0
        ");
        $stmt->execute([$hashed_password, $id]);
        $success = 'رمز عبور کاربر به 1234 بازنشانی شد';
        break;
}

// لیست کاربران
$stmt = $pdo->query("SELECT * FROM users WHERE is_admin = 0 ORDER BY created_at DESC");
$users = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت کاربران - پنل مدیریت</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <img src="../assets/images/logo.png" alt="Logo" class="sidebar-logo">
                <h2>پنل مدیریت</h2>
            </div>
            
            <nav class="sidebar-nav">
                <a href="index.php" class="nav-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>داشبورد</span>
                </a>
                <a href="upload.php" class="nav-item">
                    <i class="fas fa-upload"></i>
                    <span>آپلود جزوه</span>
                </a>
                <a href="users.php" class="nav-item active">
                    <i class="fas fa-users"></i>
                    <span>مدیریت کاربران</span>
                </a>
                <a href="reports.php" class="nav-item">
                    <i class="fas fa-flag"></i>
                    <span>گزارشات</span>
                </a>
                <a href="../dashboard.php" class="nav-item">
                    <i class="fas fa-home"></i>
                    <span>بازگشت به سایت</span>
                </a>
                <a href="../logout.php" class="nav-item logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>خروج</span>
                </a>
            </nav>
        </aside>

        <main class="admin-main">
            <header class="admin-header">
                <h1>مدیریت کاربران</h1>
                <div class="header-actions">
                    <a href="?action=create" class="btn btn-primary">
                        <i class="fas fa-user-plus"></i> ایجاد کاربر جدید
                    </a>
                </div>
            </header>

            <div class="admin-content">
                <?php if ($error): ?>
                    <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <?php if ($action == 'create'): ?>
                    <!-- فرم ایجاد کاربر -->
                    <div class="form-container">
                        <form method="POST" action="" class="user-form">
                            <div class="form-group">
                                <label for="national_code">کد ملی *</label>
                                <input type="text" id="national_code" name="national_code" 
                                       pattern="[0-9]{10}" title="کد ملی باید 10 رقم باشد" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="full_name">نام کامل *</label>
                                <input type="text" id="full_name" name="full_name" required>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ایجاد کاربر
                                </button>
                                <a href="users.php" class="btn btn-secondary">لغو</a>
                            </div>
                        </form>
                        
                        <div class="form-info">
                            <h3>توجه</h3>
                            <ul>
                                <li>رمز عبور پیش‌فرض: <strong>1234</strong></li>
                                <li>کاربر پس از اولین ورود باید رمز را تغییر دهد</li>
                                <li>کد ملی باید منحصربفرد باشد</li>
                                <li>نام باید به فارسی و کامل وارد شود</li>
                            </ul>
                        </div>
                    </div>
                    
                <?php elseif ($action == 'edit' && isset($user)): ?>
                    <!-- فرم ویرایش کاربر -->
                    <div class="form-container">
                        <form method="POST" action="" class="user-form">
                            <div class="form-group">
                                <label for="national_code">کد ملی</label>
                                <input type="text" id="national_code" value="<?php echo $user['national_code']; ?>" disabled>
                            </div>
                            
                            <div class="form-group">
                                <label for="full_name">نام کامل *</label>
                                <input type="text" id="full_name" name="full_name" 
                                       value="<?php echo $user['full_name']; ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="password">رمز عبور جدید (اختیاری)</label>
                                <input type="password" id="password" name="password" 
                                       minlength="6">
                                <small>در صورت پر کردن، رمز کاربر تغییر می‌کند</small>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تغییرات
                                </button>
                                <a href="users.php" class="btn btn-secondary">لغو</a>
                            </div>
                        </form>
                    </div>
                    
                <?php else: ?>
                    <!-- لیست کاربران -->
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>ردیف</th>
                                    <th>کد ملی</th>
                                    <th>نام کامل</th>
                                    <th>تاریخ عضویت</th>
                                    <th>آخرین ورود</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($users as $index => $user): ?>
                                <tr>
                                    <td><?php echo $index + 1; ?></td>
                                    <td><?php echo $user['national_code']; ?></td>
                                    <td><?php echo $user['full_name']; ?></td>
                                    <td><?php echo jdate('Y/m/d', strtotime($user['created_at'])); ?></td>
                                    <td>
                                        <?php echo $user['last_login'] ? jdate('Y/m/d H:i', strtotime($user['last_login'])) : 'هنوز وارد نشده'; ?>
                                    </td>
                                    <td>
                                        <span class="status-badge <?php echo $user['must_change_password'] ? 'warning' : 'success'; ?>">
                                            <?php echo $user['must_change_password'] ? 'نیازمند تغییر رمز' : 'فعال'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="?action=edit&id=<?php echo $user['id']; ?>" 
                                               class="btn btn-small btn-info" title="ویرایش">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="?action=reset_password&id=<?php echo $user['id']; ?>" 
                                               class="btn btn-small btn-warning" title="بازنشانی رمز"
                                               onclick="return confirm('آیا از بازنشانی رمز عبور مطمئن هستید؟')">
                                                <i class="fas fa-key"></i>
                                            </a>
                                            <a href="?action=delete&id=<?php echo $user['id']; ?>" 
                                               class="btn btn-small btn-danger" title="حذف"
                                               onclick="return confirm('آیا از حذف این کاربر مطمئن هستید؟')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="table-info">
                        <p>تعداد کل کاربران: <strong><?php echo count($users); ?></strong> نفر</p>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>

    <script src="../assets/js/admin.js"></script>
</body>
</html>