<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';
require_once 'includes/auth.php';

// بررسی لاگین بودن کاربر
checkAuth();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = sanitize($_POST['current_password']);
    $new_password = sanitize($_POST['new_password']);
    $confirm_password = sanitize($_POST['confirm_password']);
    
    // اعتبارسنجی
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = 'لطفا تمام فیلدها را پر کنید';
    } elseif ($new_password !== $confirm_password) {
        $error = 'رمز عبور جدید و تأیید آن مطابقت ندارند';
    } elseif (strlen($new_password) < 6) {
        $error = 'رمز عبور باید حداقل ۶ کاراکتر باشد';
    } else {
        // بررسی رمز فعلی
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($current_password, $user['password'])) {
            // بروزرسانی رمز
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE users SET password = ?, must_change_password = 0 WHERE id = ?");
            $stmt->execute([$hashed_password, $_SESSION['user_id']]);
            
            $_SESSION['must_change_password'] = 0;
            $success = 'رمز عبور با موفقیت تغییر یافت';
            
            // اگر ادمین بود و رمز پیش‌فرض داشت، ریدایرکت به پنل ادمین
            if ($_SESSION['is_admin'] && $current_password == '1234') {
                header('Location: admin/index.php');
                exit();
            } else {
                header('Location: dashboard.php');
                exit();
            }
        } else {
            $error = 'رمز عبور فعلی اشتباه است';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تغییر رمز عبور - جزوه هاب</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/extra.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="change-password-container">
        <div class="change-password-box">
            <div class="change-password-header">
                <h1>تغییر رمز عبور</h1>
                <?php if (isset($_SESSION['must_change_password']) && $_SESSION['must_change_password']): ?>
                    <div class="alert alert-warning">
                        برای امنیت حساب کاربری، لطفا رمز عبور خود را تغییر دهید
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="" class="change-password-form">
                <div class="form-group">
                    <label for="current_password">رمز عبور فعلی</label>
                    <input type="password" id="current_password" name="current_password" required>
                </div>
                
                <div class="form-group">
                    <label for="new_password">رمز عبور جدید</label>
                    <input type="password" id="new_password" name="new_password" 
                           minlength="6" required>
                    <small>حداقل ۶ کاراکتر</small>
                </div>
                
                <div class="form-group">
                    <label for="confirm_password">تأیید رمز عبور جدید</label>
                    <input type="password" id="confirm_password" name="confirm_password" 
                           minlength="6" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">تغییر رمز عبور</button>
            </form>
            
            <div class="change-password-footer">
                <a href="dashboard.php" class="btn btn-secondary">بازگشت به داشبورد</a>
            </div>
        </div>
    </div>
    
    <script src="assets/js/main.js"></script>
</body>
</html>