<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';
require_once 'includes/auth.php';

// بررسی لاگین بودن کاربر
checkAuth();

// اگر باید رمز را تغییر دهد
if (isset($_SESSION['must_change_password']) && $_SESSION['must_change_password']) {
    header('Location: change-password.php');
    exit();
}

// دریافت دروس
$stmt = $pdo->prepare("SELECT * FROM subjects WHERE is_active = 1 ORDER BY category, name");
$stmt->execute();
$subjects = $stmt->fetchAll();

// دریافت جزوات جدید
$stmt = $pdo->prepare("
    SELECT n.*, s.name as subject_name, s.category 
    FROM notes n 
    JOIN subjects s ON n.subject_id = s.id 
    WHERE n.is_active = 1 
    ORDER BY n.created_at DESC 
    LIMIT 5
");
$stmt->execute();
$recent_notes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد - جزوه هاب</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/extra.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="container">
        <header>
            <div class="logo-container">
                <img src="assets/images/logo.png" alt="Joveh Hub Logo" class="logo">
                <h1 class="site-title">جزوه هاب</h1>
            </div>
            <nav>
                <div class="user-menu">
                    <div class="user-info">
                        <img src="uploads/profile/<?php echo $_SESSION['profile_image'] ?? 'default.png'; ?>" 
                             alt="Profile" class="user-avatar">
                        <span><?php echo $_SESSION['full_name']; ?></span>
                    </div>
                    <div class="menu-dropdown">
                        <a href="dashboard.php" class="menu-item">داشبورد</a>
                        <a href="notes/view.php" class="menu-item">مشاهده جزوات</a>
                        <a href="notes/report.php" class="menu-item">گزارش مشکل</a>
                        <a href="change-password.php" class="menu-item">تغییر رمز</a>
                        <?php if ($_SESSION['is_admin']): ?>
                            <a href="admin/index.php" class="menu-item admin-link">پنل مدیریت</a>
                        <?php endif; ?>
                        <a href="logout.php" class="menu-item logout">خروج</a>
                    </div>
                </div>
            </nav>
        </header>

        <main class="dashboard">
            <div class="welcome-section">
                <h2>خوش آمدید <?php echo $_SESSION['full_name']; ?> 👋</h2>
                <p>به پنل کاربری جزوه هاب خوش آمدید. از اینجا می‌توانید به تمام جزوات دسترسی داشته باشید.</p>
            </div>

            <div class="dashboard-grid">
                <div class="card">
                    <h3>📚 جزوات جدید</h3>
                    <div class="recent-notes">
                        <?php foreach ($recent_notes as $note): ?>
                            <div class="note-item">
                                <h4><?php echo $note['title']; ?></h4>
                                <p><?php echo $note['subject_name']; ?> - 
                                   <?php echo ($note['category'] == 'specialized') ? 'تخصصی' : 'عمومی'; ?></p>
                                <a href="notes/view.php?id=<?php echo $note['id']; ?>" class="btn btn-small">مشاهده</a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="card">
                    <h3>📖 دسته‌بندی دروس</h3>
                    <div class="subject-list">
                        <div class="subject-category">
                            <h4>دروس تخصصی</h4>
                            <ul>
                                <?php 
                                $specialized = array_filter($subjects, function($subject) {
                                    return $subject['category'] == 'specialized';
                                });
                                foreach ($specialized as $subject): ?>
                                    <li><?php echo $subject['name']; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <div class="subject-category">
                            <h4>دروس عمومی</h4>
                            <ul>
                                <?php 
                                $general = array_filter($subjects, function($subject) {
                                    return $subject['category'] == 'general';
                                });
                                foreach ($general as $subject): ?>
                                    <li><?php echo $subject['name']; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="quick-actions">
                <a href="notes/view.php" class="btn btn-primary btn-large">
                    📖 مشاهده تمام جزوات
                </a>
                <a href="notes/report.php" class="btn btn-secondary btn-large">
                    🐛 گزارش مشکل در جزوه
                </a>
            </div>
        </main>

        <footer>
            <p>&copy; 2026 جزوه هاب - Joveh Hub</p>
        </footer>
    </div>

    <script src="assets/js/main.js"></script>
</body>
</html>