-- Database: joveh_hub
-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
-- Generation Time: Jan 01, 2024 at 12:00 PM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.4

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- Create database
CREATE DATABASE IF NOT EXISTS `joveh_hub` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci;
USE `joveh_hub`;

-- --------------------------------------------------------
-- Table structure for table `users`
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `national_code` varchar(10) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `profile_image` varchar(255) DEFAULT 'default.png',
  `is_admin` tinyint(1) DEFAULT 0,
  `must_change_password` tinyint(1) DEFAULT 1,
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `national_code` (`national_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Table structure for table `subjects`
CREATE TABLE `subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `category` enum('specialized','general') NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Table structure for table `notes`
CREATE TABLE `notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `file_path` varchar(255) NOT NULL,
  `prevent_download` tinyint(1) DEFAULT 1,
  `views` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `uploaded_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `subject_id` (`subject_id`),
  KEY `uploaded_by` (`uploaded_by`),
  CONSTRAINT `notes_ibfk_1` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notes_ibfk_2` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Table structure for table `reports`
CREATE TABLE `reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `note_id` int(11) NOT NULL,
  `issue_type` enum('content_error','quality_issue','missing_pages','format_issue','other') NOT NULL,
  `description` text NOT NULL,
  `status` enum('pending','seen','resolved') DEFAULT 'pending',
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `resolved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `note_id` (`note_id`),
  CONSTRAINT `reports_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reports_ibfk_2` FOREIGN KEY (`note_id`) REFERENCES `notes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Table structure for table `login_attempts`
CREATE TABLE `login_attempts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) NOT NULL,
  `national_code` varchar(10) NOT NULL,
  `attempt_time` datetime NOT NULL DEFAULT current_timestamp(),
  `success` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ip_address` (`ip_address`),
  KEY `national_code` (`national_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Table structure for table `activity_logs`
CREATE TABLE `activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `activity_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- --------------------------------------------------------
-- Insert default data
-- Insert admin user
INSERT INTO `users` (`national_code`, `full_name`, `password`, `profile_image`, `is_admin`, `must_change_password`, `created_at`) 
VALUES ('admin', 'مدیر سیستم', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'default.png', 1, 0, NOW());

-- Insert default subjects (specialized)
INSERT INTO `subjects` (`name`, `category`, `created_at`) VALUES
('حسابان 1', 'specialized', NOW()),
('فیزیک 2', 'specialized', NOW()),
('شیمی 2', 'specialized', NOW()),
('هندسه 2', 'specialized', NOW()),
('آمار و احتمال', 'specialized', NOW());

-- Insert default subjects (general)
INSERT INTO `subjects` (`name`, `category`, `created_at`) VALUES
('زمین شناسی', 'general', NOW()),
('تاریخ معاصر ایران', 'general', NOW()),
('انسان و محیط زیست', 'general', NOW()),
('فارسی 2', 'general', NOW()),
('نگارش 2', 'general', NOW()),
('دین و زندگی 2', 'general', NOW()),
('زبان انگلیسی 2', 'general', NOW()),
('آزمایشگاه علوم تجربی 2', 'general', NOW()),
('عربی 2', 'general', NOW());

-- --------------------------------------------------------
-- Create indexes for better performance
CREATE INDEX idx_users_created ON users(created_at);
CREATE INDEX idx_notes_created ON notes(created_at);
CREATE INDEX idx_notes_subject ON notes(subject_id, is_active);
CREATE INDEX idx_reports_status ON reports(status, created_at);
CREATE INDEX idx_activity_user ON activity_logs(user_id, created_at);

-- --------------------------------------------------------
-- Create views for easier queries
CREATE VIEW view_active_notes AS
SELECT n.*, s.name as subject_name, s.category, u.full_name as uploader_name
FROM notes n
JOIN subjects s ON n.subject_id = s.id
JOIN users u ON n.uploaded_by = u.id
WHERE n.is_active = 1;

CREATE VIEW view_user_stats AS
SELECT 
    u.id,
    u.national_code,
    u.full_name,
    COUNT(DISTINCT n.id) as total_notes,
    COUNT(DISTINCT r.id) as total_reports,
    u.last_login,
    u.created_at
FROM users u
LEFT JOIN notes n ON u.id = n.uploaded_by
LEFT JOIN reports r ON u.id = r.user_id
WHERE u.is_admin = 0
GROUP BY u.id;

-- --------------------------------------------------------
-- Create stored procedures
DELIMITER //

CREATE PROCEDURE sp_get_user_notes(IN user_id INT)
BEGIN
    SELECT n.*, s.name as subject_name
    FROM notes n
    JOIN subjects s ON n.subject_id = s.id
    WHERE n.uploaded_by = user_id
    AND n.is_active = 1
    ORDER BY n.created_at DESC;
END //

CREATE PROCEDURE sp_get_dashboard_stats()
BEGIN
    SELECT 
        (SELECT COUNT(*) FROM users WHERE is_admin = 0) as total_users,
        (SELECT COUNT(*) FROM notes WHERE is_active = 1) as total_notes,
        (SELECT COUNT(*) FROM reports WHERE status = 'pending') as pending_reports,
        (SELECT COUNT(*) FROM subjects WHERE is_active = 1) as total_subjects;
END //

CREATE PROCEDURE sp_search_notes(IN search_term VARCHAR(200))
BEGIN
    SELECT n.*, s.name as subject_name, s.category, u.full_name as uploader_name
    FROM notes n
    JOIN subjects s ON n.subject_id = s.id
    JOIN users u ON n.uploaded_by = u.id
    WHERE n.is_active = 1
    AND (n.title LIKE CONCAT('%', search_term, '%') 
         OR n.description LIKE CONCAT('%', search_term, '%')
         OR s.name LIKE CONCAT('%', search_term, '%'))
    ORDER BY n.created_at DESC;
END //

DELIMITER ;

-- --------------------------------------------------------
-- Create triggers
DELIMITER //

CREATE TRIGGER trg_note_insert
AFTER INSERT ON notes
FOR EACH ROW
BEGIN
    INSERT INTO activity_logs (user_id, action, description)
    VALUES (NEW.uploaded_by, 'upload_note', 
            CONCAT('آپلود جزوه جدید: ', NEW.title));
END //

CREATE TRIGGER trg_report_insert
AFTER INSERT ON reports
FOR EACH ROW
BEGIN
    INSERT INTO activity_logs (user_id, action, description)
    VALUES (NEW.user_id, 'report_issue', 
            CONCAT('گزارش مشکل برای جزوه: ', 
                   (SELECT title FROM notes WHERE id = NEW.note_id)));
END //

CREATE TRIGGER trg_user_login
AFTER UPDATE ON users
FOR EACH ROW
BEGIN
    IF NEW.last_login IS NOT NULL AND OLD.last_login IS NULL THEN
        INSERT INTO activity_logs (user_id, action, description)
        VALUES (NEW.id, 'first_login', 'اولین ورود به سیستم');
    END IF;
END //

DELIMITER ;

-- --------------------------------------------------------
-- Create events for maintenance
DELIMITER //

CREATE EVENT ev_cleanup_login_attempts
ON SCHEDULE EVERY 1 DAY
STARTS CURRENT_TIMESTAMP
DO
BEGIN
    DELETE FROM login_attempts 
    WHERE attempt_time < DATE_SUB(NOW(), INTERVAL 30 DAY);
    
    DELETE FROM activity_logs 
    WHERE created_at < DATE_SUB(NOW(), INTERVAL 90 DAY);
END //

DELIMITER ;

-- --------------------------------------------------------
-- Create functions
DELIMITER //

CREATE FUNCTION fn_get_user_role(user_id INT) 
RETURNS VARCHAR(20)
DETERMINISTIC
BEGIN
    DECLARE user_role VARCHAR(20);
    
    SELECT CASE 
        WHEN is_admin = 1 THEN 'admin'
        ELSE 'user'
    END INTO user_role
    FROM users
    WHERE id = user_id;
    
    RETURN user_role;
END //

CREATE FUNCTION fn_count_user_notes(user_id INT) 
RETURNS INT
DETERMINISTIC
BEGIN
    DECLARE note_count INT;
    
    SELECT COUNT(*) INTO note_count
    FROM notes
    WHERE uploaded_by = user_id
    AND is_active = 1;
    
    RETURN note_count;
END //

DELIMITER ;

-- --------------------------------------------------------
-- Set up privileges
-- Create a limited privilege user for the application
CREATE USER 'joveh_app'@'localhost' IDENTIFIED BY 'StrongPassword123!';
GRANT SELECT, INSERT, UPDATE, DELETE ON joveh_hub.* TO 'joveh_app'@'localhost';
GRANT EXECUTE ON PROCEDURE joveh_hub.* TO 'joveh_app'@'localhost';
FLUSH PRIVILEGES;

COMMIT;