<?php
// تابع بررسی لاگین بودن کاربر
function checkAuth() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: ../login.php');
        exit();
    }
}

// تابع بررسی ادمین بودن
function checkAdmin() {
    checkAuth();
    
    if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
}

// تابع احراز هویت کاربر
function authenticateUser($national_code, $password) {
    global $pdo;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE national_code = ?");
    $stmt->execute([$national_code]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        // بروزرسانی آخرین زمان ورود
        $stmt = $pdo->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
        $stmt->execute([$user['id']]);
        
        return $user;
    }
    
    return false;
}

// تابع ایجاد ادمین اصلی
function createAdminUser() {
    global $pdo;
    
    // بررسی وجود ادمین
    $stmt = $pdo->query("SELECT id FROM users WHERE is_admin = 1");
    if ($stmt->rowCount() == 0) {
        $hashed_password = password_hash('@Ss13871387$', PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("
            INSERT INTO users (national_code, full_name, password, is_admin, must_change_password, created_at)
            VALUES (?, ?, ?, 1, 0, NOW())
        ");
        $stmt->execute(['admin', 'مدیر سیستم', $hashed_password]);
    }
}

// تابع ایجاد دروس پیش‌فرض
function createDefaultSubjects() {
    global $pdo;
    
    $subjects = [
        // دروس تخصصی
        ['حسابان 1', 'specialized'],
        ['فیزیک 2', 'specialized'],
        ['شیمی 2', 'specialized'],
        ['هندسه 2', 'specialized'],
        ['آمار و احتمال', 'specialized'],
        
        // دروس عمومی
        ['زمین شناسی', 'general'],
        ['تاریخ معاصر ایران', 'general'],
        ['انسان و محیط زیست', 'general'],
        ['فارسی 2', 'general'],
        ['نگارش 2', 'general'],
        ['دین و زندگی 2', 'general'],
        ['زبان انگلیسی 2', 'general'],
        ['آزمایشگاه علوم تجربی 2', 'general'],
        ['عربی 2', 'general']
    ];
    
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM subjects");
    $result = $stmt->fetch();
    
    if ($result['count'] == 0) {
        $stmt = $pdo->prepare("INSERT INTO subjects (name, category, is_active, created_at) VALUES (?, ?, 1, NOW())");
        
        foreach ($subjects as $subject) {
            $stmt->execute($subject);
        }
    }
}

// تابع بررسی CSRF Token
function checkCSRFToken() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
            die('خطای امنیتی: توکن نامعتبر است');
        }
    }
}

// تابع محدود کردن دسترسی
function restrictAccess($allowed_roles = []) {
    checkAuth();
    
    if (!empty($allowed_roles)) {
        if (!in_array($_SESSION['role'], $allowed_roles)) {
            header('HTTP/1.0 403 Forbidden');
            die('شما دسترسی به این صفحه ندارید');
        }
    }
}
?>