<?php
// تابع جلوگیری از XSS
function sanitize($input) {
    if (is_array($input)) {
        foreach ($input as $key => $value) {
            $input[$key] = sanitize($value);
        }
        return $input;
    }
    
    $input = trim($input);
    $input = stripslashes($input);
    $input = htmlspecialchars($input, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    return $input;
}

// تابع اعتبارسنجی کد ملی
function validateNationalCode($code) {
    if (!preg_match('/^[0-9]{10}$/', $code)) {
        return false;
    }
    
    // الگوریتم اعتبارسنجی کد ملی
    $sum = 0;
    for ($i = 0; $i < 9; $i++) {
        $sum += (int)$code[$i] * (10 - $i);
    }
    
    $remainder = $sum % 11;
    $control_digit = (int)$code[9];
    
    if (($remainder < 2 && $control_digit == $remainder) || 
        ($remainder >= 2 && $control_digit == (11 - $remainder))) {
        return true;
    }
    
    return false;
}

// تابع تبدیل تاریخ میلادی به شمسی
function jdate($format, $timestamp = null) {
    if ($timestamp === null) {
        $timestamp = time();
    }
    
    $date = date('Y-m-d H:i:s', $timestamp);
    $g_y = date('Y', $timestamp);
    $g_m = date('m', $timestamp);
    $g_d = date('d', $timestamp);
    
    $d_4 = $g_y % 4;
    $g_a = array(0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $doy_g = $g_a[(int)$g_m] + $g_d;
    
    if ($d_4 == 0 && $g_m > 2) {
        $doy_g++;
    }
    
    $d_33 = (int)((($g_y - 16) % 132) * 0.0305);
    $a = ($d_33 == 3 or $d_33 < ($d_4 - 1) or $d_4 == 0) ? 286 : 287;
    $b = (($d_33 == 1 or $d_33 == 2) and ($d_33 == $d_4 or $d_4 == 1)) ? 78 : (($d_33 == 3 and $d_4 == 0) ? 80 : 79);
    
    if ((int)(($g_y - 10) / 63) == 30) {
        $a--;
        $b++;
    }
    
    if ($doy_g > $b) {
        $jy = $g_y - 621;
        $doy_j = $doy_g - $b;
    } else {
        $jy = $g_y - 622;
        $doy_j = $doy_g + $a;
    }
    
    if ($doy_j < 187) {
        $jm = (int)(($doy_j - 1) / 31);
        $jd = $doy_j - (31 * $jm++);
    } else {
        $jm = (int)(($doy_j - 187) / 30);
        $jd = $doy_j - 186 - ($jm * 30);
        $jm += 7;
    }
    
    $result = $format;
    $result = str_replace('Y', $jy, $result);
    $result = str_replace('m', str_pad($jm, 2, '0', STR_PAD_LEFT), $result);
    $result = str_replace('d', str_pad($jd, 2, '0', STR_PAD_LEFT), $result);
    $result = str_replace('H', date('H', $timestamp), $result);
    $result = str_replace('i', date('i', $timestamp), $result);
    $result = str_replace('s', date('s', $timestamp), $result);
    
    return $result;
}

// تابع نمایش زمان گذشته
function time_ago($datetime) {
    $time = strtotime($datetime);
    $now = time();
    $diff = $now - $time;
    
    if ($diff < 60) {
        return 'همین حالا';
    } elseif ($diff < 3600) {
        $minutes = floor($diff / 60);
        return $minutes . ' دقیقه قبل';
    } elseif ($diff < 86400) {
        $hours = floor($diff / 3600);
        return $hours . ' ساعت قبل';
    } elseif ($diff < 2592000) {
        $days = floor($diff / 86400);
        return $days . ' روز قبل';
    } elseif ($diff < 31536000) {
        $months = floor($diff / 2592000);
        return $months . ' ماه قبل';
    } else {
        $years = floor($diff / 31536000);
        return $years . ' سال قبل';
    }
}

// تابع تولید تصویر پیشفرض
function generateDefaultAvatar($name) {
    $colors = ['#3498db', '#2ecc71', '#9b59b6', '#e74c3c', '#f39c12', '#1abc9c'];
    $color = $colors[hexdec(substr(md5($name), 0, 6)) % count($colors)];
    
    $initials = '';
    $name_parts = explode(' ', $name);
    foreach ($name_parts as $part) {
        $initials .= mb_substr($part, 0, 1, 'UTF-8');
    }
    
    return [
        'color' => $color,
        'initials' => mb_substr($initials, 0, 2, 'UTF-8')
    ];
}

// تابع بررسی نوع فایل
function checkFileType($file_path) {
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime_type = finfo_file($finfo, $file_path);
    finfo_close($finfo);
    
    return $mime_type;
}

// تابع امنیتی برای جلوگیری از حملات
function secure_path($path) {
    $path = str_replace(['../', './'], '', $path);
    $path = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
    return $path;
}

// تابع ایجاد فولدر
function createDirectory($path) {
    if (!file_exists($path)) {
        mkdir($path, 0755, true);
    }
}
?>