<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

// اگر کاربر لاگین کرده، به داشبورد هدایت شود
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جزوه هاب - Joveh Hub</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/extra.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="icon" href="assets/images/logo.png" type="image/png">
</head>
<body>
    <div class="container">
        <header>
            <div class="logo-container">
                <img src="assets/images/logo.png" alt="Joveh Hub Logo" class="logo">
                <h1 class="site-title">جزوه هاب</h1>
                <h2 class="site-subtitle">Joveh Hub</h2>
            </div>
            <nav>
                <a href="login.php" class="btn btn-primary">ورود به سیستم</a>
            </nav>
        </header>

        <main class="hero">
            <div class="hero-content">
                <h2>مرجع تخصصی جزوات آموزشی</h2>
                <p>دسترسی به جامع‌ترین مجموعه جزوات دروس یازدهم</p>
                <div class="features">
                    <div class="feature">
                        <span class="feature-icon">📚</span>
                        <h3>جزوات طبقه‌بندی شده</h3>
                        <p>دروس تخصصی و عمومی به صورت جداگانه</p>
                    </div>
                    <div class="feature">
                        <span class="feature-icon">🔒</span>
                        <h3>امنیت بالا</h3>
                        <p>جلوگیری از دانلود و کپی‌برداری</p>
                    </div>
                    <div class="feature">
                        <span class="feature-icon">📖</span>
                        <h3>مطالعه آسان</h3>
                        <p>پی‌دی‌اف خوان حرفه‌ای با قابلیت‌های پیشرفته</p>
                    </div>
                </div>
            </div>
        </main>

        <section class="subjects">
            <h2>دروس پایه یازدهم</h2>
            <div class="subject-categories">
                <div class="category">
                    <h3>دروس تخصصی</h3>
                    <ul>
                        <li>حسابان 1</li>
                        <li>فیزیک 2</li>
                        <li>شیمی 2</li>
                        <li>هندسه 2</li>
                        <li>آمار و احتمال</li>
                    </ul>
                </div>
                <div class="category">
                    <h3>دروس عمومی</h3>
                    <ul>
                        <li>زمین شناسی</li>
                        <li>تاریخ معاصر ایران</li>
                        <li>انسان و محیط زیست</li>
                        <li>فارسی 2</li>
                        <li>نگارش 2</li>
                        <li>دین و زندگی 2</li>
                        <li>زبان انگلیسی 2</li>
                        <li>آزمایشگاه علوم تجربی 2</li>
                        <li>عربی 2</li>
                    </ul>
                </div>
            </div>
        </section>

        <footer>
            <p>&copy; 2026 جزوه هاب - Joveh Hub. تمامی حقوق محفوظ است.</p>
            <p class="footer-note">این سایت با هدف کمک به یادگیری دانش‌آموزان طراحی شده است.</p>
        </footer>
    </div>

    <script src="assets/js/main.js"></script>
</body>
</html>