<?php
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';
require_once 'includes/auth.php';

// اگر کاربر لاگین کرده، به داشبورد هدایت شود
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $national_code = sanitize($_POST['national_code']);
    $password = sanitize($_POST['password']);
    
    if (empty($national_code) || empty($password)) {
        $error = 'لطفا کد ملی و رمز عبور را وارد کنید';
    } else {
        $user = authenticateUser($national_code, $password);
        
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['national_code'] = $user['national_code'];
            $_SESSION['full_name'] = $user['full_name'];
            $_SESSION['is_admin'] = $user['is_admin'];
            $_SESSION['must_change_password'] = $user['must_change_password'];
            $_SESSION['profile_image'] = $user['profile_image'];
            
            // اگر باید رمز را تغییر دهد، به صفحه تغییر رمز هدایت شود
            if ($user['must_change_password']) {
                $_SESSION['change_password'] = true;
                header('Location: change-password.php');
                exit();
            }
            
            header('Location: dashboard.php');
            exit();
        } else {
            $error = 'کد ملی یا رمز عبور اشتباه است';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به سیستم - جزوه هاب</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/extra.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <div class="login-header">
                <img src="assets/images/logo.png" alt="Logo" class="login-logo">
                <h1>ورود به جزوه هاب</h1>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="" class="login-form">
                <div class="form-group">
                    <label for="national_code">کد ملی</label>
                    <input type="text" id="national_code" name="national_code" 
                           required pattern="[0-9]{10}" title="کد ملی باید 10 رقم باشد">
                </div>
                
                <div class="form-group">
                    <label for="password">رمز عبور</label>
                    <input type="password" id="password" name="password" required>
                    <small>رمز پیش‌فرض: 1234</small>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">ورود به سیستم</button>
            </form>
            
            <div class="login-footer">
                <p>ورود فقط با کد ملی امکان‌پذیر است</p>
                <p>پس از اولین ورود باید رمز عبور خود را تغییر دهید</p>
            </div>
        </div>
    </div>
    
    <script src="assets/js/main.js"></script>
</body>
</html>