<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی لاگین بودن کاربر
checkAuth();

$note_id = $_GET['id'] ?? 0;
$error = '';
$success = '';

// دریافت اطلاعات جزوه
if ($note_id) {
    $stmt = $pdo->prepare("
        SELECT n.title, s.name as subject_name
        FROM notes n
        JOIN subjects s ON n.subject_id = s.id
        WHERE n.id = ?
    ");
    $stmt->execute([$note_id]);
    $note = $stmt->fetch();
} else {
    header('Location: ../dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $description = sanitize($_POST['description']);
    $issue_type = sanitize($_POST['issue_type']);
    
    if (empty($description)) {
        $error = 'لطفا توضیحات مشکل را وارد کنید';
    } else {
        // ذخیره گزارش
        $stmt = $pdo->prepare("
            INSERT INTO reports (user_id, note_id, issue_type, description, status, created_at)
            VALUES (?, ?, ?, ?, 'pending', NOW())
        ");
        $stmt->execute([$_SESSION['user_id'], $note_id, $issue_type, $description]);
        
        $success = 'گزارش شما با موفقیت ثبت شد. متشکریم از مشارکت شما!';
        $_POST = array();
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش مشکل - جزوه هاب</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <header>
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Joveh Hub Logo" class="logo">
                <h1 class="site-title">جزوه هاب</h1>
            </div>
            <nav>
                <div class="user-menu">
                    <div class="user-info">
                        <img src="../uploads/profile/<?php echo $_SESSION['profile_image'] ?? 'default.png'; ?>" 
                             alt="Profile" class="user-avatar">
                        <span><?php echo $_SESSION['full_name']; ?></span>
                    </div>
                    <div class="menu-dropdown">
                        <a href="../dashboard.php" class="menu-item">داشبورد</a>
                        <a href="view.php?id=<?php echo $note_id; ?>" class="menu-item">بازگشت به جزوه</a>
                        <a href="report.php?id=<?php echo $note_id; ?>" class="menu-item active">گزارش مشکل</a>
                        <a href="../change-password.php" class="menu-item">تغییر رمز</a>
                        <?php if ($_SESSION['is_admin']): ?>
                            <a href="../admin/index.php" class="menu-item admin-link">پنل مدیریت</a>
                        <?php endif; ?>
                        <a href="../logout.php" class="menu-item logout">خروج</a>
                    </div>
                </div>
            </nav>
        </header>

        <main class="report-page">
            <div class="report-container">
                <div class="report-header">
                    <h1><i class="fas fa-flag"></i> گزارش مشکل در جزوه</h1>
                    <div class="note-preview">
                        <h3>جزوه: <?php echo $note['title']; ?></h3>
                        <p>درس: <?php echo $note['subject_name']; ?></p>
                    </div>
                </div>
                
                <?php if ($error): ?>
                    <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <form method="POST" action="" class="report-form">
                    <div class="form-group">
                        <label for="issue_type">نوع مشکل *</label>
                        <select id="issue_type" name="issue_type" required>
                            <option value="">انتخاب نوع مشکل</option>
                            <option value="content_error" <?php echo isset($_POST['issue_type']) && $_POST['issue_type'] == 'content_error' ? 'selected' : ''; ?>>خطا در محتوا</option>
                            <option value="quality_issue" <?php echo isset($_POST['issue_type']) && $_POST['issue_type'] == 'quality_issue' ? 'selected' : ''; ?>>کیفیت پایین تصاویر</option>
                            <option value="missing_pages" <?php echo isset($_POST['issue_type']) && $_POST['issue_type'] == 'missing_pages' ? 'selected' : ''; ?>>صفحات مفقودی</option>
                            <option value="format_issue" <?php echo isset($_POST['issue_type']) && $_POST['issue_type'] == 'format_issue' ? 'selected' : ''; ?>>مشکل در فرمت</option>
                            <option value="other" <?php echo isset($_POST['issue_type']) && $_POST['issue_type'] == 'other' ? 'selected' : ''; ?>>سایر</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">توضیحات مشکل *</label>
                        <textarea id="description" name="description" rows="6" 
                                  placeholder="لطفا مشکل را به طور کامل توضیح دهید. هرچه دقیق‌تر باشید، سریع‌تر می‌توانیم مشکل را حل کنیم." 
                                  required><?php echo $_POST['description'] ?? ''; ?></textarea>
                        <small class="help-text">
                            مثال: در صفحه ۵، فرمول شماره ۳ اشتباه نوشته شده است.
                        </small>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> ارسال گزارش
                        </button>
                        <a href="view.php?id=<?php echo $note_id; ?>" class="btn btn-secondary">لغو و بازگشت</a>
                    </div>
                </form>
                
                <div class="report-guidelines">
                    <h3>راهنمای گزارش مشکلات:</h3>
                    <ul>
                        <li>مشکل را دقیق و واضح توضیح دهید</li>
                        <li>در صورت امکان شماره صفحه را ذکر کنید</li>
                        <li>گزارشات شما محرمانه باقی می‌ماند</li>
                        <li>گزارشات ظرف ۲۴ ساعت بررسی می‌شوند</li>
                        <li>از گزارشات شما برای بهبود کیفیت استفاده می‌شود</li>
                    </ul>
                </div>
            </div>
        </main>

        <footer>
            <p>&copy; 2026 جزوه هاب - Joveh Hub</p>
        </footer>
    </div>

    <script src="../assets/js/main.js"></script>
</body>
</html>