<?php
session_start();
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// بررسی لاگین بودن کاربر
checkAuth();

$id = $_GET['id'] ?? 0;
if (!$id) {
    header('Location: ../dashboard.php');
    exit();
}

// دریافت اطلاعات جزوه
$stmt = $pdo->prepare("
    SELECT n.*, s.name as subject_name, s.category, 
           u.full_name as uploader_name,
           n.prevent_download
    FROM notes n
    JOIN subjects s ON n.subject_id = s.id
    JOIN users u ON n.uploaded_by = u.id
    WHERE n.id = ? AND n.is_active = 1
");
$stmt->execute([$id]);
$note = $stmt->fetch();

if (!$note) {
    header('Location: ../dashboard.php');
    exit();
}

// افزایش تعداد بازدید
$stmt = $pdo->prepare("UPDATE notes SET views = views + 1 WHERE id = ?");
$stmt->execute([$id]);

// دریافت جزوات مرتبط
$stmt = $pdo->prepare("
    SELECT n.*, s.name as subject_name
    FROM notes n
    JOIN subjects s ON n.subject_id = s.id
    WHERE n.subject_id = ? AND n.id != ? AND n.is_active = 1
    ORDER BY n.created_at DESC
    LIMIT 5
");
$stmt->execute([$note['subject_id'], $id]);
$related_notes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $note['title']; ?> - جزوه هاب</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/pdf-viewer.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <header>
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Joveh Hub Logo" class="logo">
                <h1 class="site-title">جزوه هاب</h1>
            </div>
            <nav>
                <div class="user-menu">
                    <div class="user-info">
                        <img src="../uploads/profile/<?php echo $_SESSION['profile_image'] ?? 'default.png'; ?>" 
                             alt="Profile" class="user-avatar">
                        <span><?php echo $_SESSION['full_name']; ?></span>
                    </div>
                    <div class="menu-dropdown">
                        <a href="../dashboard.php" class="menu-item">داشبورد</a>
                        <a href="view.php?id=<?php echo $id; ?>" class="menu-item active">مطالعه جزوه</a>
                        <a href="report.php?id=<?php echo $id; ?>" class="menu-item">گزارش مشکل</a>
                        <a href="../change-password.php" class="menu-item">تغییر رمز</a>
                        <?php if ($_SESSION['is_admin']): ?>
                            <a href="../admin/index.php" class="menu-item admin-link">پنل مدیریت</a>
                        <?php endif; ?>
                        <a href="../logout.php" class="menu-item logout">خروج</a>
                    </div>
                </div>
            </nav>
        </header>

        <main class="note-viewer">
            <!-- نوار اطلاعات جزوه -->
            <div class="note-header">
                <div class="note-info">
                    <h1><?php echo $note['title']; ?></h1>
                    <div class="note-meta">
                        <span class="meta-item">
                            <i class="fas fa-book"></i>
                            <?php echo $note['subject_name']; ?>
                        </span>
                        <span class="meta-item">
                            <i class="fas fa-user"></i>
                            <?php echo $note['uploader_name']; ?>
                        </span>
                        <span class="meta-item">
                            <i class="fas fa-calendar"></i>
                            <?php echo jdate('Y/m/d', strtotime($note['created_at'])); ?>
                        </span>
                        <span class="meta-item">
                            <i class="fas fa-eye"></i>
                            <?php echo $note['views'] + 1; ?> بازدید
                        </span>
                        <span class="meta-item category-badge <?php echo $note['category']; ?>">
                            <?php echo $note['category'] == 'specialized' ? 'تخصصی' : 'عمومی'; ?>
                        </span>
                    </div>
                    
                    <?php if ($note['description']): ?>
                        <div class="note-description">
                            <p><?php echo nl2br(htmlspecialchars($note['description'])); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="note-actions">
                    <a href="report.php?id=<?php echo $id; ?>" class="btn btn-warning">
                        <i class="fas fa-flag"></i> گزارش مشکل
                    </a>
                    <a href="../dashboard.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> بازگشت
                    </a>
                </div>
            </div>

            <!-- PDF Viewer -->
            <div class="pdf-viewer-container">
                <div class="pdf-viewer-header">
                    <h2><i class="fas fa-file-pdf"></i> مشاهده جزوه</h2>
                    <div class="viewer-controls">
                        <button id="zoom-in" class="btn btn-small">
                            <i class="fas fa-search-plus"></i>
                        </button>
                        <button id="zoom-out" class="btn btn-small">
                            <i class="fas fa-search-minus"></i>
                        </button>
                        <button id="prev-page" class="btn btn-small">
                            <i class="fas fa-arrow-right"></i> قبلی
                        </button>
                        <span id="page-info">صفحه <span id="current-page">1</span> از <span id="total-pages">-</span></span>
                        <button id="next-page" class="btn btn-small">
                            بعدی <i class="fas fa-arrow-left"></i>
                        </button>
                        <button id="fullscreen" class="btn btn-small">
                            <i class="fas fa-expand"></i>
                        </button>
                    </div>
                </div>
                
                <div class="pdf-viewer-wrapper" id="pdf-viewer-wrapper">
                    <div class="pdf-loading">
                        <i class="fas fa-spinner fa-spin"></i>
                        <p>در حال بارگذاری جزوه...</p>
                    </div>
                    <canvas id="pdf-canvas"></canvas>
                </div>
                
                <div class="pdf-security-info">
                    <i class="fas fa-shield-alt"></i>
                    <p>امنیت بالا: این جزوه تنها قابل مشاهده است و امکان دانلود، کپی یا چاپ وجود ندارد.</p>
                    <?php if ($note['prevent_download']): ?>
                        <span class="security-badge">
                            <i class="fas fa-lock"></i> جلوگیری از دانلود فعال است
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <!-- جزوات مرتبط -->
            <?php if (!empty($related_notes)): ?>
                <div class="related-notes">
                    <h3><i class="fas fa-link"></i> جزوات مرتبط</h3>
                    <div class="related-grid">
                        <?php foreach ($related_notes as $related): ?>
                            <div class="related-card">
                                <h4><?php echo $related['title']; ?></h4>
                                <p><?php echo $related['subject_name']; ?></p>
                                <a href="view.php?id=<?php echo $related['id']; ?>" class="btn btn-small">
                                    مشاهده جزوه
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </main>

        <footer>
            <p>&copy; 2026 جزوه هاب - Joveh Hub</p>
        </footer>
    </div>

    <!-- PDF.js Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        // تنظیمات PDF.js worker
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
    </script>
    <script src="../assets/js/pdf-viewer.js"></script>
    
    <script>
        // بارگذاری PDF
        const pdfUrl = '../uploads/notes/<?php echo $note['file_path']; ?>';
        const pdfViewer = new PDFViewer(pdfUrl);
        
        // جلوگیری از دانلود و چاپ
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
        });
        
        document.addEventListener('keydown', function(e) {
            // جلوگیری از کلیدهای ترکیبی
            if (e.ctrlKey && (e.key === 's' || e.key === 'p' || e.key === 'c')) {
                e.preventDefault();
            }
            
            // جلوگیری از F12 و کلیدهای توسعه
            if (e.key === 'F12' || (e.ctrlKey && e.shiftKey && (e.key === 'I' || e.key === 'J' || e.key === 'C'))) {
                e.preventDefault();
            }
        });
        
        // جلوگیری از دکمه راست کلیک در canvas
        const canvas = document.getElementById('pdf-canvas');
        if (canvas) {
            canvas.addEventListener('contextmenu', function(e) {
                e.preventDefault();
            });
        }
    </script>
</body>
</html>